<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class Amarillolimonlimitcategoryresults extends Module
{
    const CONFIG_KEY = 'AMARILLO_LIMIT_RESULTS_PER_PAGE';
    const DEFAULT_LIMIT = 60;

    public function __construct()
    {
        $this->name = 'amarillolimonlimitcategoryresults';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Javier Pardo - Amarillo Limón';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Amarillo Limón - Limitar resultados por página en categorías');
        $this->description = $this->l('Limita el número máximo de productos por página en los listados para evitar errores de memoria y colapso de recursos del servidor.');

        $this->ps_versions_compliancy = ['min' => '1.7', 'max' => _PS_VERSION_];
    }

    public function install()
    {
        return parent::install()
            && $this->registerHook('actionProductSearchProviderRunQueryBefore')
            && Configuration::updateValue(self::CONFIG_KEY, self::DEFAULT_LIMIT);
    }

    public function uninstall()
    {
        Configuration::deleteByName(self::CONFIG_KEY);

        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';

        if (Tools::isSubmit('submit_' . $this->name)) {
            $limit = (int) Tools::getValue(self::CONFIG_KEY);

            if ($limit <= 0) {
                $output .= $this->displayError($this->l('El límite debe ser un número mayor que 0.'));
            } else {
                Configuration::updateValue(self::CONFIG_KEY, $limit);
                $output .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
            }
        }

        return $output . $this->renderForm();
    }

    private function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submit_' . $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            . '&configure=' . $this->name
            . '&tab_module=' . $this->tab
            . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = [
            'fields_value' => $this->getConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        ];

        return $helper->generateForm([$this->getConfigForm()]);
    }

    private function getConfigForm()
    {
        return [
            'form' => [
                'legend' => [
                    'title' => $this->l('Configuración'),
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'text',
                        'label' => $this->l('Límite máximo de resultados por página'),
                        'name' => self::CONFIG_KEY,
                        'size' => 10,
                        'required' => true,
                        'desc' => $this->l('Número máximo de productos que se pueden solicitar por página mediante el parámetro resultsPerPage en la URL. Se recomienda un valor entre 60 y 120.'),
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Guardar'),
                ],
            ],
        ];
    }

    private function getConfigFormValues()
    {
        return [
            self::CONFIG_KEY => Configuration::get(self::CONFIG_KEY, self::DEFAULT_LIMIT),
        ];
    }

    public function hookActionProductSearchProviderRunQueryBefore(array $params)
    {
        /** @var \PrestaShop\PrestaShop\Core\Product\Search\ProductSearchQuery $query */
        $query = $params['query'];
        $limit = (int) Configuration::get(self::CONFIG_KEY);

        if ($limit <= 0) {
            $limit = self::DEFAULT_LIMIT;
        }

        if ($query->getResultsPerPage() > $limit) {
            $query->setResultsPerPage($limit);
        }
    }
}
